# A button class
import pygame


class Button:  # A basic screen button widget

    def __init__(self, scr, xx, yy, w, h):
        self.x = xx                   # Location: (x,y)
        self.y = yy
        self.width = w                # Size: width, height
        self.height = h
        self.label = ""               # Text label
        self.scr = scr                # Destination screen
        self.color = (200, 200, 200)  # Button color
        self.image = None

    def set_label(self, s):
        self.label = s
    def get_label(self):
        return s

    def set_color(self, c):
        self.color = c

    def get_color(self):
        return self.color

    def set_image(self, im):
        self.image = im

    def get_image(self):
        return self.image

    def armed(self):
        m = pygame.mouse.get_pos()
        if self.x <= m[0] <= self.x+self.width and m[1]>=self.y and m[1]<=self.y+self.height :
            return True
        return False

    def draw(self):
        if self.armed():
            pygame.draw.rect(self.scr, (120, 220, 100), pygame.Rect(self.x, self.y, self.width, self.height))
        else:
            pygame.draw.rect(self.scr, (0, 0, 0), pygame.Rect(self.x, self.y, self.width, self.height), 1)
        pygame.draw.rect(self.scr, (0, 0, 0), pygame.Rect(self.x+3, self.y+3, self.width-6, self.height-6), 1)
        pygame.draw.rect(self.scr, self.color, pygame.Rect(self.x+4, self.y+4, self.width-8, self.height-8))
        if self.image is not None:
            self.scr.blit(self.image, (self.x+4, self.y+4))
